/*
 * Decompiled with CFR 0.152.
 */
package artifacts.common.config;

import artifacts.common.config.ClientConfig;
import artifacts.common.config.CommonConfig;
import artifacts.common.config.ServerConfig;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(modid="artifacts", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ModConfig {
    public static CommonConfig common;
    public static ServerConfig server;
    public static ClientConfig client;
    private static ForgeConfigSpec commonSpec;
    private static ForgeConfigSpec serverSpec;

    public static void registerCommon() {
        Pair commonSpecPair = new ForgeConfigSpec.Builder().configure(CommonConfig::new);
        common = (CommonConfig)commonSpecPair.getLeft();
        commonSpec = (ForgeConfigSpec)commonSpecPair.getRight();
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)commonSpec);
    }

    public static void registerClient() {
        Pair clientSpecPair = new ForgeConfigSpec.Builder().configure(ClientConfig::new);
        ForgeConfigSpec clientSpec = (ForgeConfigSpec)clientSpecPair.getRight();
        client = (ClientConfig)clientSpecPair.getLeft();
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)clientSpec);
    }

    public static void registerServer() {
        Pair serverSpecPair = new ForgeConfigSpec.Builder().configure(ServerConfig::new);
        server = (ServerConfig)serverSpecPair.getLeft();
        serverSpec = (ForgeConfigSpec)serverSpecPair.getRight();
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)serverSpec);
    }

    @SubscribeEvent
    public static void onModConfigEvent(ModConfigEvent configEvent) {
        if (configEvent.getConfig().getSpec() == commonSpec) {
            common.bake();
        } else if (configEvent.getConfig().getSpec() == serverSpec) {
            server.bake();
        }
    }
}

